
* PROGRAM: OOPCV1P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR    = c:\oopc_d\input;
%LET PROGDIR     = c:\oopc_d\programs;
%LET PBPDIR      = c:\pbp2021;
%LET FORMDIR     = c:\oopc_d\formulary;
%LET PLANFILEDIR = c:\oopc_d\programs;
%LET OUTPUT      = c:\oopc_d\output;

%LET INPUT=INPUTPLAN;

OPTIONS OBS = MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO = 6
   SORTPGM = SAS  NOSORTEQUALS THREADS = YES NOTES SPOOL;
OPTIONS VALIDVARNAME=ANY;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0     "&INPUTDIR.";
LIBNAME  IN1     "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;

*SET UP MACRO VARIABLES FOR YEARS;
%LET PBPMAIN       = PBP2021.MDB;
%LET RUNYEAR       = 2021;
%LET PARTB_PREMIUM = 144.60; 
%LET GENERIC_GAP_DISCOUNT = 0.75;
%LET BRAND_GAP_DISCOUNT = 0.70;
%LET BRAND_GAP_LIABDISC = 0.05;
%LET DEDUCTIBLE_&RUNYEAR = 445;
%LET ICL_&RUNYEAR = 4130;
%LET TROOP_&RUNYEAR = 6550;
%LET THRESHOLD_&RUNYEAR = 10048.39;
%LET CATGENERIC_&RUNYEAR = 3.70;
%LET CATBRAND_&RUNYEAR = 9.20;

%LET MODVERSION=OOPC2020CMSV1.ZIP;
%LET PDEYEAR=2018;
%LET FRFDATE=20190927;
%LET OACT_INFLATION_YEAR=2019;
%LET MED_FINANCE_RATE_YEAR=2019;
%LET GENSUBDATE=NA;
* CMS VERSION - UPDATE WITH EXTRACT DATE;
%LET EXTDATE=YYYYMMDD;

%INCLUDE IN0(CLEANUP);

%MACRO PLANS(PLANFILE);
  %IF "&PLANFILE" NE "" %THEN %DO;
    DATA MASTER_PLANFILE;
    INFILE "&PLANFILE";
    INPUT @1 HPLAN $CHAR11.;
    RUN;
  %END;
  %ELSE %DO;
    DATA MASTER_PLANFILE;
    STOP;
    RUN;
  %END;
%MEND;

%PLANS(&PLANFILEDIR\PLANFILE.TXT);
RUN;

DATA _NULL_;
  CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET MASTER_PLANFILE NOBS=NUMOBS;
  STOP;
RUN;

%INCLUDE IN0(OOPCV1M.SAS)/SOURCE2;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

data _NULL_;
  if 0 then set master_planfile nobs=n;
  call symputx('nrows',n);
  stop;
run;

%macro batchrun(iter);
  %do i=1 %to &iter.;
    data planfile;
      set master_planfile;
      iteration = input("&i.",4.);
      plancnt = input("&nrows.",4.);
      start_rec =  (iteration - 1) * ceil(plancnt/&iter.);
      end_rec =  (iteration) * ceil(plancnt/&iter.);
      if start_rec < _n_ <= end_rec;
    run;
    
    data _NULL_;
      if 0 then set planfile nobs=n;
      call symputx('nobsrows',n);
     stop;
    run;
    
    %if "&nobsrows." > "0" %then %do;
    
      %OOPCV1M(RUNYEAR          =2021,
              INP               =IN1.PERSON,
              PBP               =&PBPDIR,
              FORMULARY         =&FORMDIR);
      RUN; 
    
    %end;
     
    PROC DATASETS;
    DELETE RXCUI_MASTER_FILE RICPME_SAMPLE_COHORT FREEFILL PBP_PLANS;
    RUN;
      
  %END;
%MEND;

%batchrun(1);

%INCLUDE IN0(PLAN_LEVEL)/SOURCE2;
RUN;

%INCLUDE IN0(FFS_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;

%INCLUDE IN0(PLAN_CATNAME_NEW)/SOURCE2;
RUN;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
